<?php
// Check if running from command line and password provided as argument
if (PHP_SAPI === 'cli' && isset($argv[1])) {
    $password = $argv[1];
} else {
    // Default password if none provided
    $password = 'admin123';
}

$hash = password_hash($password, PASSWORD_DEFAULT);

// Output depends on context
if (PHP_SAPI === 'cli') {
    echo "Password: $password\n";
    echo "Hash: $hash\n";
    echo "Verify: " . (password_verify($password, $hash) ? 'True' : 'False') . "\n";
} else {
    echo "Password: $password<br>";
    echo "Hash: $hash<br>";
    echo "Verify: " . (password_verify($password, $hash) ? 'True' : 'False');
}
?> 