# Warung Klontong Rakha E-commerce

Website e-commerce sederhana untuk Warung Klontong Rakha menggunakan PHP dan MySQL.

## Fitur

- Halaman beranda dengan produk unggulan
- Halaman produk dengan filter kategori
- Detail produk
- Keranjang belanja
- Checkout dan pemesanan
- Profil pengguna
- Panel admin terpisah
- Manajemen produk dan kategori
- Manajemen pesanan
- Manajemen pengguna

## Persyaratan

- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- Web server (Apache/Nginx)

## Instalasi

1. **Clone repositori atau unggah file ke server web**

2. **Buat database MySQL**

   Buka phpMyAdmin atau MySQL client favorit Anda, lalu buat database baru bernama `warung_klontong_rakha`.

3. **Impor struktur database**

   Impor file SQL dari folder `database/setup.sql` ke database yang baru dibuat.

4. **Konfigurasi koneksi database**

   Edit file `includes/config.php` dan sesuaikan pengaturan database:

   ```php
   define('DB_HOST', 'localhost'); // Host database
   define('DB_NAME', 'warung_klontong_rakha'); // Nama database
   define('DB_USER', 'root'); // Username database
   define('DB_PASS', ''); // Password database
   ```

5. **Sesuaikan URL situs**

   Pada file yang sama (`includes/config.php`), sesuaikan URL situs:

   ```php
   define('SITE_URL', 'http://localhost/rakha/');
   ```

6. **Buat folder untuk gambar produk**

   Buat folder `uploads/products` jika belum ada, dan pastikan folder tersebut memiliki izin tulis (write permission).

7. **Akses situs**

   Buka browser dan akses situs Anda sesuai dengan pengaturan yang telah dibuat.

## Login Admin

Akun admin default:
- Username: `admin`
- Password: `admin123`

## Login User

Untuk mengakses sebagai pengguna reguler, Anda perlu mendaftar terlebih dahulu melalui halaman pendaftaran.

## Struktur Folder

- `admin/` - Panel administrasi
- `assets/` - File CSS, JavaScript, dan gambar
- `cart/` - Fungsi keranjang belanja
- `checkout/` - Proses checkout
- `database/` - File SQL
- `includes/` - File-file yang disertakan seperti header, footer, dan konfigurasi
- `products/` - Halaman produk
- `user/` - Halaman pengguna seperti login, pendaftaran, dan profil
- `uploads/` - Folder untuk unggahan gambar

## Keamanan

- Password dienkripsi menggunakan bcrypt
- Validasi input untuk mencegah SQL Injection
- Sanitasi output untuk mencegah XSS

## Lisensi

Proyek ini dilisensikan di bawah lisensi MIT. 8