<?php
require_once '../includes/config.php';

// Only allow admin to run this script
if (!isAdminLoggedIn()) {
    die('Unauthorized access');
}

try {
    $conn = connectDB();
    
    // Check if payment_proof column exists in orders table
    $stmt = $conn->prepare("SHOW COLUMNS FROM orders LIKE 'payment_proof'");
    $stmt->execute();
    
    if ($stmt->rowCount() === 0) {
        // Add payment_proof column
        $stmt = $conn->prepare("ALTER TABLE orders ADD payment_proof VARCHAR(255) NULL");
        $stmt->execute();
        echo "Successfully added 'payment_proof' column to orders table";
    } else {
        echo "'payment_proof' column already exists in orders table";
    }
    
} catch (PDOException $e) {
    die("Error: " . $e->getMessage());
}
?> 